/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.forge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.lifecycle.LifecycleOwner;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.TooltipRenderer;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.forge.CenterFragment2;
import icyllis.modernui.mc.forge.Config;
import icyllis.modernui.mc.forge.SimpleScreen;
import icyllis.modernui.mc.mixin.AccessNativeImage;
import icyllis.modernui.text.TextUtils;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL45C;

@ApiStatus.Internal
public final class UIManagerForge
extends UIManager
implements LifecycleOwner {
    public static final KeyMapping OPEN_CENTER_KEY = new KeyMapping("key.modernui.openCenter", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 75, "Modern UI");
    public static final KeyMapping ZOOM_KEY = new KeyMapping("key.modernui.zoom", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 67, "Modern UI");
    public static final Field BY_PATH = ObfuscationReflectionHelper.findField(TextureManager.class, (String)"f_118468_");
    public static final Field TEXTURES_BY_NAME = ObfuscationReflectionHelper.findField(TextureAtlas.class, (String)"f_118264_");
    public static final Field TEXTURE_ID = ObfuscationReflectionHelper.findField(AbstractTexture.class, (String)"f_117950_");

    private UIManagerForge() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @RenderThread
    static void initialize() {
        Core.checkRenderThread();
        assert (sInstance == null);
        sInstance = new UIManagerForge();
        ModernUI.LOGGER.info(MARKER, "UI manager initialized");
    }

    @Override
    @MainThread
    protected void open(@Nonnull Fragment fragment) {
        if (!this.minecraft.m_18695_()) {
            throw new IllegalStateException("Not called from main thread");
        }
        this.minecraft.m_91152_((Screen)new SimpleScreen(this, fragment, null, null, null));
    }

    @Override
    protected void onScreenChange(@Nullable Screen oldScreen, @Nullable Screen newScreen) {
        if (newScreen != null) {
            if (this.mScreen != newScreen && newScreen instanceof MuiScreen) {
                this.mElapsedTimeMillis = 0L;
            }
            if (this.mScreen != newScreen && this.mScreen != null) {
                this.onHoverMove(false);
            }
            if (this.mScreen == null && this.minecraft.f_91080_ == null) {
                this.mElapsedTimeMillis = 0L;
            }
        }
        super.onScreenChange(oldScreen, newScreen);
    }

    @SubscribeEvent
    void onPostMouseInput(@Nonnull InputEvent.MouseButton.Post event) {
        super.onPostMouseInput(event.getButton(), event.getAction(), event.getModifiers());
    }

    @Override
    protected void onPreKeyInput(int keyCode, int scanCode, int action, int mods) {
        InputConstants.Key key;
        if (action == 1 && (this.minecraft.f_91080_ == null || this.minecraft.f_91080_.m_6913_() || this.minecraft.f_91080_ instanceof TitleScreen) && OPEN_CENTER_KEY.isActiveAndMatches(key = InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.open(new CenterFragment2());
            return;
        }
        super.onPreKeyInput(keyCode, scanCode, action, mods);
    }

    @Override
    public void onGameLoadFinished() {
        super.onGameLoadFinished();
        Config.CLIENT.mLastWindowMode.apply();
    }

    @Override
    public void dump(@NotNull PrintWriter pw, boolean fragments) {
        super.dump(pw, fragments);
        Map textureMap = null;
        try {
            textureMap = (Map)BY_PATH.get(this.minecraft.m_91097_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GLDevice device = (GLDevice)Core.requireImmediateContext().getDevice();
        if (textureMap != null && device.getCaps().hasDSASupport()) {
            long gpuSize = 0L;
            long cpuSize = 0L;
            int dynamicTextures = 0;
            int textureAtlases = 0;
            int atlasSprites = 0;
            for (AbstractTexture texture : textureMap.values()) {
                try {
                    int tex = TEXTURE_ID.getInt(texture);
                    if (GL45C.glIsTexture((int)tex)) {
                        int internalFormat = GL45C.glGetTextureLevelParameteri((int)tex, (int)0, (int)4099);
                        long width = GL45C.glGetTextureLevelParameteri((int)tex, (int)0, (int)4096);
                        long height = GL45C.glGetTextureLevelParameteri((int)tex, (int)0, (int)4097);
                        int maxLevel = GL45C.glGetTextureParameteri((int)tex, (int)33085);
                        int bpp = switch (internalFormat) {
                            case 6403, 33321 -> 1;
                            case 33319, 33323 -> 2;
                            case 6407, 6408, 32849, 32856 -> 4;
                            default -> 0;
                        };
                        long size = width * height * (long)bpp;
                        if (maxLevel > 0) {
                            size = (size - (size >> (maxLevel + 1 << 1)) << 2) / 3L;
                        }
                        gpuSize += size;
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                if (texture instanceof DynamicTexture) {
                    DynamicTexture dynamicTexture = (DynamicTexture)texture;
                    NativeImage image = dynamicTexture.m_117991_();
                    try {
                        if (image != null && ((AccessNativeImage)image).getPixels() != 0L) {
                            cpuSize += (long)image.m_84982_() * (long)image.m_85084_() * (long)image.m_85102_().m_85161_();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++dynamicTextures;
                }
                if (!(texture instanceof TextureAtlas)) continue;
                TextureAtlas textureAtlas = (TextureAtlas)texture;
                try {
                    Map textures = (Map)TEXTURES_BY_NAME.get(textureAtlas);
                    atlasSprites += textures.size();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++textureAtlases;
            }
            pw.print("Minecraft's TextureManager: ");
            pw.print("Textures=" + textureMap.size());
            pw.print(", DynamicTextures=" + dynamicTextures);
            pw.print(", Atlases=" + textureAtlases);
            pw.print(", Sprites=" + atlasSprites);
            pw.print(", GPUMemory=" + TextUtils.binaryCompact(gpuSize) + " (" + gpuSize + " bytes)");
            pw.println(", CPUMemory=" + TextUtils.binaryCompact(cpuSize) + " (" + cpuSize + " bytes)");
        }
    }

    @SubscribeEvent
    void onRenderGameOverlayLayer(@Nonnull RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && this.mScreen != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    void onRenderTooltipH(@Nonnull RenderTooltipEvent.Pre event) {
        if (TooltipRenderer.sTooltip) {
            this.drawExtTooltip(event.getItemStack(), event.getGraphics(), event.getComponents(), event.getX(), event.getY(), event.getFont(), event.getScreenWidth(), event.getScreenHeight(), event.getTooltipPositioner());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void onRenderTooltipL(@Nonnull RenderTooltipEvent.Pre event) {
        if (TooltipRenderer.sTooltip) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    void onRenderTick(@Nonnull TickEvent.RenderTickEvent event) {
        super.onRenderTick(event.phase == TickEvent.Phase.END);
    }

    @SubscribeEvent
    void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        super.onClientTick(event.phase == TickEvent.Phase.END);
    }

    @SubscribeEvent
    void onChangeFov(@Nonnull ViewportEvent.ComputeFov event) {
        boolean zoomActive = false;
        if (sZoomEnabled && this.minecraft.f_91080_ == null) {
            zoomActive = ZOOM_KEY.m_90857_();
        }
        if (zoomActive) {
            if (!this.mZoomMode) {
                this.mZoomMode = true;
                this.mZoomSmoothCamera = this.minecraft.f_91066_.f_92067_;
                this.minecraft.f_91066_.f_92067_ = true;
                this.minecraft.f_91060_.m_109826_();
            }
            event.setFOV(event.getFOV() * 0.25);
        } else if (this.mZoomMode) {
            this.mZoomMode = false;
            this.minecraft.f_91066_.f_92067_ = this.mZoomSmoothCamera;
            this.minecraft.f_91060_.m_109826_();
        }
    }
}

